\name{Wspec-class}
\docType{class}
\alias{Wspec-class}
\alias{[,Wspec-method}
\alias{Wspec}
\title{Class Wspec}
\description{Class \dQuote{Wspec} (\emph{W}ave \emph{spec}trums).
    Objects of this class represent a bunch of periodograms 
    (see \code{\link{periodogram}}, each generated by \code{\link{spectrum}})
    corresponding to one or several windows of one \code{\link{Wave}} object.
    Redundancy (e.g. same frequencies in each of the periodograms) will be omitted, 
    hence reducing memory consumption.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("Wspec", ...)},
but regularly they will be created by calls to the function \code{\link{periodogram}}.
}
\section{Slots}{
    The following slots are defined. For details see the constructor function \code{\link{periodogram}}.
  \describe{
    \item{\code{freq}:}{Object of class \code{"numeric"}}
    \item{\code{spec}:}{Object of class \code{"list"}}
    \item{\code{kernel}:}{Object of class \code{"ANY"}}
    \item{\code{df}:}{Object of class \code{"numeric"}}
    \item{\code{taper}:}{Object of class \code{"numeric"}}
    \item{\code{width}:}{Object of class \code{"numeric"}}
    \item{\code{overlap}:}{Object of class \code{"numeric"}}
    \item{\code{normalize}:}{Object of class \code{"logical"}}
    \item{\code{starts}:}{Object of class \code{"numeric"}}
    \item{\code{stereo}:}{Object of class \code{"logical"}}
    \item{\code{samp.rate}:}{Object of class \code{"numeric"}}
    \item{\code{variance}:}{Object of class \code{"numeric"}}
    \item{\code{energy}:}{Object of class \code{"numeric"}}
  }
}
\details{
The subset function \dQuote{\code{[}} extracts the selected 
elements of slots \code{spec}, \code{starts}, \code{variance} and \code{energy}
and returns the other slots unchanged.
}
\author{Uwe Ligges, \email{ligges@statistik.tu-dortmund.de}}
\seealso{\itemize{
    \item the \code{show}, \code{plot} and \code{summary} methods,
    \item for the constructor function and some examples: \code{\link{periodogram}} 
        (and hence also \code{\link{spec.pgram}}, \link{Wave-class}, and \code{\link{Wave}})
    \item \code{\link{WspecMat}} for a similar class that represents the spectrum in form of a matrix.
    }
}
\keyword{classes}
\concept{periodogram}
\concept{spectrum}
\concept{music}
\concept{speech}
\concept{Wave}
