% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bwCov}
\alias{bwCov}
\title{Covariance Bandwidth Calculation by Cross-Validation
\emph{bwCov} calculates a single bandwidth to estimate the time-varying variance-
covariance matrix.}
\usage{
bwCov(
  x,
  z = NULL,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian")
)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{z}{A vector with the variable over which coefficients are smooth over.}

\item{cv.block}{A positive scalar with the size of the block in leave-one block-out cross-validation.
By default 'cv.block=0' meaning leave-one-out cross-validation.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{A character, either "Triweight" (default), "Epa" or "Gaussian" kernel function.}
}
\value{
A scalar.
}
\description{
Covariance Bandwidth Calculation by Cross-Validation
\emph{bwCov} calculates a single bandwidth to estimate the time-varying variance-
covariance matrix.
}
\examples{

data(CEES)
## Using a shorter set for a quick example. Variable "Date" is removed.
mydata <- tail (CEES[, -1], 50)
bw.cov <- bwCov(mydata)
Sigma.hat <- tvCov(mydata, bw = bw.cov)

}
