% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CfFuncs.R
\name{npv}
\alias{npv}
\title{Net Present Value of a periodic cashflow (NPV)}
\usage{
npv(i, cf, ts = seq(from = 0, by = 1, along.with = cf))
}
\arguments{
\item{i}{The rate used to discount the cashflow. It must be effective and with a periodicity that matches that of the cashflow}

\item{cf}{The cashflow}

\item{ts}{The times on which the cashflow ocurrs. It is assumed that \code{cf[idx]} happens at moment \code{ts[idx]}. If empty, assumes that \code{cf[idx]} happens at period \code{idx - 1}}
}
\value{
The net present value at
}
\description{
Net Present Value of a periodic cashflow (NPV)
}
\examples{
npv(i = 0.01, cf = c(-1, 0.5, 0.9), ts = c(0, 1, 3))
}

