#' @describeIn GSMAR Log-likelihood method
#' @inheritParams plot.gsmar
#' @param object object of class \code{'gsmar'} generated by \code{fitGSMAR()} or \code{GSMAR()}.
#' @export
logLik.gsmar <- function(object, ...) object$loglik


#' @describeIn GSMAR residuals method to extract multivariate quantile residuals
#' @inheritParams logLik.gsmar
#' @export
residuals.gsmar <- function(object, ...) object$quantile_residuals


#' @describeIn GSMAR summary method
#' @inheritParams logLik.gsmar
#' @export
summary.gsmar <- function(object, ...) {
  gsmar <- object
  check_data(gsmar)
  structure(list(gsmar=gsmar,
                 regime_means=get_regime_means(gsmar)),
            class="gsmarsum")
}
