% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{diagnosticPlot}
\alias{diagnosticPlot}
\title{Quantile residual based diagnostic plots for GMAR, StMAR and G-StMAR models}
\usage{
diagnosticPlot(gsmar, nlags = 20, nsimu = 2000, plot_indstats = FALSE)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}

\item{nlags}{a positive integer specifying how many lags should be calculated for the autocorrelation and
conditional heteroscedasticity statistics.}

\item{nsimu}{a positive integer specifying to how many simulated values from the process the covariance
matrix "Omega" (used to compute the tests) should be based on. Larger number of simulations may result
more reliable tests. If smaller than data size, then it will be based on the given data.
Ignored if \code{plot_indstats==FALSE}.}

\item{plot_indstats}{set \code{TRUE} if the individual statistics discussed in Kalliovirta (2012) should be
plotted with their approximate 95\% critical bounds (this may take some time).}
}
\value{
\code{diagnosticPlot} only plots to a graphical device and doesn't return anything. Use the
 function \code{quantileResidualTests} in order to obtain the individual statistics.
}
\description{
\code{diagnosticPlot} plots quantile residual time series, normal QQ-plot, autocorrelation function
 and squared quantile residual autocorrelation function. There is an option to also plot the individual statistics
 associated with the quantile residual tests (for autocorrelation and conditional heteroskedasticity) divided by
 their approximate standard errors with their approximate 95\% critical bounds.
}
\details{
Sometimes the individual statistics are not plotted because it's not (numerically) possible for
 to calculate all the necessary estimates required. This may suggest that the model is misspecified.

 The dashed lines plotted with autocorrelation functions (for quantile residuals and their squares) are
 plus-minus \eqn{1.96*T^{-1/2}}.
}
\section{Suggested packages}{

  Install the suggested package "gsl" for faster evaluations in the cases of StMAR and G-StMAR models.
  For large StMAR and G-StMAR models with large data the calculations to obtain the individual statistics
  may take a significantly long time without the package "gsl".
}

\examples{
\donttest{
# GMAR model
params13 <- c(1.4, 0.88, 0.26, 2.46, 0.82, 0.74, 5.0, 0.68, 5.2, 0.72, 0.2)
gmar13 <- GSMAR(data=VIX, p=1, M=3, params=params13, model="GMAR")
diagnosticPlot(gmar13)

# Restricted GMAR model: plot also the individual statistics with
# their approximate critical bounds using the given data
params12r <- c(1.4, 1.8, 0.88, 0.29, 3.18, 0.84)
gmar12r <- GSMAR(data=VIX, p=1, M=2, params=params12r, model="GMAR",
 restricted=TRUE)
diagnosticPlot(gmar12r, nlags=10, nsimu=1, plot_indstats=TRUE)

# StMAR model
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 100, 3.6)
stmar12 <- GSMAR(data=VIX, p=1, M=2, params=params12t, model="StMAR")
diagnosticPlot(stmar12)

# G-StMAR model (similar to the StMAR model above)
params12gs <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 3.6)
gstmar12 <- GSMAR(data=VIX, p=1, M=c(1, 1), params=params12gs,
 model="G-StMAR")
diagnosticPlot(gstmar12)

# Restricted G-StMAR-model
params13gsr <- c(1.3, 1, 1.4, 0.8, 0.4, 2, 0.2, 0.25, 0.15, 20)
gstmar13r <- GSMAR(data=VIX, p=1, M=c(2, 1), params=params13gsr,
 model="G-StMAR", restricted=TRUE)
diagnosticPlot(gstmar13r)

# GMAR model as a mixture of AR(2) and AR(1) models
constraints <- list(diag(1, ncol=2, nrow=2), as.matrix(c(1, 0)))
params22c <- c(1.2, 0.85, 0.04, 0.3, 3.3, 0.77, 2.8, 0.77)
gmar22c <- GSMAR(data=VIX, p=2, M=2, params=params22c,
 model="GMAR", constraints=constraints)
diagnosticPlot(gmar22c)

# Such StMAR(3,2) that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
params32trc <- c(2.2, 1.8, 0.88, -0.03, 2.4, 0.27, 0.40, 3.9, 1000)
stmar32rc <- GSMAR(data=VIX, p=3, M=2, params=params32trc, model="StMAR",
 restricted=TRUE, constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
diagnosticPlot(stmar32rc)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis.
           \emph{Springer}.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for G-StMAR model, but it's a straight forward generalization with
           theoretical properties similar to GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{quantileResidualTests}}, \code{\link{predict.gsmar}}
}
