% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plot.gsmarpred}
\alias{plot.gsmarpred}
\title{plot method for class 'gsmarpred' objects}
\usage{
\method{plot}{gsmarpred}(x, ..., nt, add_grid = TRUE)
}
\arguments{
\item{x}{object of class \code{'gsmarpred'} created with \code{predict.gsmar}.}

\item{...}{arguments passed to \code{grid}}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction. Default is \code{round(length(data)*0.2)}.}

\item{add_grid}{should grid be added to the plots?}
}
\description{
\code{plot.gsmarpred} is plot method for gsmarpred objects
}
\details{
This method is used plot forecasts of gsmar processes
}
\examples{
 \donttest{
 # GMAR-model
 params12 <- c(0.18281409, 0.92657275, 0.00214552,
  0.85725129, 0.68210294, 0.01900299, 0.88342018)
 gmar12 <- GSMAR(logVIX, 1, 2, params12)
 pred <- predict(gmar12, n_ahead=10, plotRes=FALSE)
 plot(pred, nt=50)
 }
}
