% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecDraw.R
\name{vecDraw}
\alias{vecDraw}
\title{digitizing vector features using a simple leaflet base map}
\usage{
vecDraw(
  mapCenter = NULL,
  zoom = 15,
  line = TRUE,
  rectangle = TRUE,
  poly = TRUE,
  circle = TRUE,
  point = TRUE,
  remove = TRUE,
  position = "topright",
  maplayer = c("CartoDB.Positron", "OpenStreetMap", "Esri.WorldImagery",
    "Thunderforest.Landscape", "OpenTopoMap"),
  overlay = NULL,
  preset = "all",
  locPreset = "muf",
  cex = 10,
  lwd = 2,
  opacity = 0.7
)
}
\arguments{
\item{mapCenter}{center of the leaflet map}

\item{zoom}{set initial zoom level of leaflet map}

\item{line}{enable/disable line tool}

\item{rectangle}{enable/disable polygon tool}

\item{poly}{enable/disable polygon tool}

\item{circle}{enable/disable circle tool}

\item{point}{enable/disable point tool}

\item{remove}{enable/disable the remove feature of the draw tool}

\item{position}{toolbar layout (topright, topleft, bottomright, bottomleft)}

\item{maplayer}{string as provided by leaflet-provider}

\item{overlay}{optional sp* object may used for orientation}

\item{preset}{character default is "uav" for line based mission digitizing, "ext" for rectangles, NULL for all drawing items}

\item{locPreset}{character location preset, default is "muf" for Marburg University Forest,  "tra" Traddelstein, "hag" Hagenstein, "baw" Bayerwald.}

\item{cex}{size of item}

\item{lwd}{line width of item}

\item{opacity}{opacity of item}
}
\description{
vecDraw is designed for straightforward digitizing of simple geometries without adding attributes. It provides a bunch of leaflet base maps and optionally a sf* object can be loaded for orientation.
}
\note{
Yu can either save the digitized object to a json (JS) or kml (KML) file.
}
\examples{
\dontrun{
# fully featured without overlay
require(mapview)

# preset for digitizing uav flight areas using Meuse data set as overlay
require(sp)
data(meuse) 
sp::coordinates(meuse) <- ~x+y 
sp::proj4string(meuse) <-CRS("+init=epsg:28992") 
m <- sp::spTransform(meuse,CRSobj = sp::CRS("+init=epsg:4326"))
vecDraw(overlay = m, preset = "uav")
  
# preset for digitizing simple rectangles extents
vecDraw(preset="ext",overlay = m)
}
}
