% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{gg_axis}
\alias{gg_axis}
\title{Make Pretty ggplot x- or y-Axis Log 10 Scale}
\usage{
gg_axis(fo, yaxis_scale = TRUE, xaxis_scale = TRUE, ylim_min = NULL,
  ylim_max = NULL, xlim_min = NULL, xlim_max = NULL,
  x_tick_label = TRUE, y_tick_label = TRUE)
}
\arguments{
\item{fo}{ggplot figure object}

\item{yaxis_scale}{\code{TRUE} indicates that the y-axis should be log10 scaled}

\item{xaxis_scale}{\code{TRUE} indicates that the x-axis should be log10 scaled}

\item{ylim_min}{set to a number to define the lower bound of the y-axis}

\item{ylim_max}{set to a number to define the upper bound of the y-axis}

\item{xlim_min}{set to a number to define the lower bound of the x-axis}

\item{xlim_max}{set to a number to define the upper bound of the x-axis}

\item{x_tick_label}{\code{TRUE} to show x tick labels, \code{FALSE} to hide the x tick labels}

\item{y_tick_label}{\code{TRUE} to show y tick labels, \code{FALSE} to hide the y tick labels}
}
\value{
ggplot object with formatted axis
}
\description{
used to convert the x and y-axis of a ggplot to a log 10 scale that is more visually satisfying than the ggplot default.
}
\examples{
library("ggplot2")
df = data.frame(x = seq(0.01,10,.01),
               y = seq(0.01,10,.01)^2)
p       = ggplot(df, aes(x=x, y=y)) + geom_line()
# pretty up the axes
p       = prepare_figure(fo=p, purpose="print")
# pretty log10 y-axis 
p_logy  = gg_log10_yaxis(fo=p)
# pretty log10 x-axis 
p_logx  = gg_log10_xaxis(fo=p)
# pretty log10 yx-axis 
p_logxy = gg_axis(fo=p)
}
\seealso{
\code{\link{gg_log10_xaxis}} and \code{\link{gg_log10_yaxis}}
}
