% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_nca_summary}
\alias{system_nca_summary}
\title{Summarize NCA Results in Tabular Format}
\usage{
system_nca_summary(
  cfg,
  analysis_name = "analysis",
  treat_as_factor = c("ID", "Dose_Number", "Dose"),
  params_include = c("ID", "cmax", "tmax", "auclast"),
  params_header = NULL,
  rptname = "default",
  label_format = NULL,
  summary_stats = NULL,
  summary_labels = list(MEAN = "Mean", STD = "Std Dev", MEDIAN = "Median", N = "N obs",
    SE = "Std Err."),
  summary_location = NULL,
  ds_wrangle = NULL,
  digits = 3,
  table_theme = "theme_zebra"
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{analysis_name}{string containing the name of the analysis (default \code{'analysis'}) that was previously run}

\item{treat_as_factor}{sequence of column names to be treated as factors (default \code{c("ID", "Dose_Number", "Dose")}). Use this to report values without added decimals.}

\item{params_include}{vector with names of parameters to include (default c("ID", "cmax", "tmax", "auclast"))}

\item{params_header}{list with names of parameters followed by a vector of headers. You can use the placeholder "<label>" to include the standard label (e.g. list(cmax=c("<label>", "(ng/ml)"))), with a default of \code{NULL}.}

\item{rptname}{report name (either PowerPoint or Word) that this table will be used in (\code{"default"})}

\item{label_format}{string containing the format in which headers and labels are being specified, either \code{"text"}, or \code{"md"} (default \code{NULL} assumes \code{"text"} format)}

\item{summary_stats}{list with strings as names containing placeholders for
summary statistics and the values indicate the parameters to apply those
statistics to. for example, if you want to calculate mean and standard deviation of
AUClast you could use \code{list("<MEAN> (<STD>)"=c("auclast")}. This would create
a row at the bottom of the table with this information for just the listed
parameters. To split this up across two rows just do the following:
\code{list("<MEAN>"=c("auclast"), "<STD>"=c("auclast"))}. Any NA values
will be ignored when calculating statistics.  The allowed
summary statistics are the mean (<MEAN>), median (<MEDIAN>), standard
deviation (<STD>), standard error (<SE>), and the number of observations
used to calculate statistics. (<N>). The default value of \code{NULL}
prevents any summary statistics from being included.}

\item{summary_labels}{list containing the mapping of summary statistics
defined by \code{summary_stats} with their text labels in the output tables: 
\preformatted{
list(MEAN   = "Mean", 
     STD    = "Std Dev", 
     MEDIAN = "Median", 
     N      = "N obs", 
     SE     = "Std Err.")}}

\item{summary_location}{column where to put the labels (e.g. Mean (Std)) for
summary statistic. The default (\code{NULL}) will leave these labels off.
If you set this to the "ID" column it will put them under the subject IDs.}

\item{ds_wrangle}{\preformatted{
 ds_wrangle = list(Dose=c(30), Dose_Number = c(1))
}}

\item{digits}{number of significant digits to report (3) or \code{NULL} to prevent rounding}

\item{table_theme}{flextable theme see the flextable package for available themes, and set to \code{NULL} to prevent themes from being applied. (default=\code{"theme_zebra"})}
}
\value{
list with the following elements
\itemize{
  \item{isgood} Boolean variable indicating success (\code{TRUE}) or failure (\code{FALSE}) if the call is successful the following will be defined (\code{NULL} 
  \item{nca_summary} dataframe containing the summary table with headers and any summary statistics appended to the bottom
  \item{nca_summary_ft} same information in the \code{nca_summary} ouput as a flextable object
  \item{components}  list with the elements of the summary table each as dataframes (header, data, and summary)
}
}
\description{
Creates tabular summaries of NCA results
}
\seealso{
Vignette on NCA (\code{vignette("NCA", package = "ubiquity")})
}
