% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{AUC_Bailers_method}
\alias{AUC_Bailers_method}
\title{Calculate AUC for Sparse Data}
\usage{
AUC_Bailers_method(
  conc_data = NULL,
  dsmap = list(NTIME = "NTIME", CONC = "CONC", ID = "ID")
)
}
\arguments{
\item{conc_data}{data frame containing the sparse data}

\item{dsmap}{list with names specifying the columns:
\itemize{
 \item \code{NTIME}       Nominal time since last dose;  \code{"NTIME"} (default)
 \item \code{CONC}        Concentration data;  \code{"CONC"} (default)
 \item \code{ID}          Subject ID;  (\code{"ID"} (default)
}}
}
\value{
list with the following elements
\itemize{
 \item \code{isgood}   Boolean value indicating the result of the function call
 \item \code{AUC}      Mean AUC
 \item \code{var_AUC}  Variance of the AUC
 \item \code{msgs}     Sequence of strings contianing a description of any problems 
 \item \code{obss}     Internal of observations
 \item \code{times}    Sequence of time corresponding to the rows of \code{obs}
 \item \code{r}        number of observations at each time point (rows correspond to rows of \code{obs})
}
}
\description{
This is an implementation of Bailors method for calculating AUCs with
sparse sampling. It is taken from the following publication:

Nedelman, J. R., Gibiansky, E., & Lau, D. T. (1995). Applying Bailer's
method for AUC confidence intervals to sparse sampling Pharmaceutical
Research, 12(1), 124-128.
}
\keyword{internal}
