% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{detect_raw_enc}
\alias{detect_raw_enc}
\title{Raw bytes encoding detection}
\usage{
detect_raw_enc(x)
}
\arguments{
\item{x}{Raw vector.}
}
\value{
A character which contains a guessed iconv-compatible encoding name.
}
\description{
This function tries to detect raw bytes encoding.
}
\examples{
# detect raw vector encoding with ASCII encoding
ascii <- "I can eat glass and it doesn't hurt me."
detect_raw_enc(charToRaw(ascii))

# detect raw vector with UTF-8 encoding
utf8 <- "\u4e0b\u5348\u597d"
detect_raw_enc(charToRaw(utf8))

# function to read file as raw bytes
read_bin <- function(x) readBin(x, raw(), file.size(x))

# detect encoding of files read as raw vector
ex_path <- system.file("examples", package = "uchardet")

# deutsch text as binary data
de_bin <- read_bin(file.path(ex_path, "de", "windows-1252.txt"))
detect_raw_enc(de_bin)

# russian text as binary data
ru_bin <- read_bin(file.path(ex_path, "ru", "windows-1251.txt"))
detect_raw_enc(ru_bin)

# china text as binary data
zh_bin <- read_bin(file.path(ex_path, "zh", "utf-8.txt"))
detect_raw_enc(zh_bin)

# detect encoding of the web pages content
\donttest{
if (require("curl")) {
  detect_url_enc <- function(u) detect_raw_enc(curl_fetch_memory(u)$content)
  detect_url_enc("https://www.corriere.it")
  detect_url_enc("https://www.vk.com")
  detect_url_enc("https://www.qq.com")
  detect_url_enc("https://kakaku.com")
  detect_url_enc("https://etoland.co.kr")
}
}
}
