% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{get_data}
\alias{get_data}
\title{Retrieve Data from the Database}
\usage{
get_data(
  dsid = NULL,
  series = NULL,
  from = NULL,
  to = NULL,
  labels = TRUE,
  wide = TRUE,
  expand.date = FALSE,
  ordered = TRUE,
  return.query = FALSE,
  ...
)
}
\arguments{
\item{dsid}{character. (Optional) id's of datasets matching the 'DSID' column of the 'DATASET' table (retrieved using \code{\link[=datasets]{datasets()}}). If none of the following arguments are used, all series from those datasets will be returned.}

\item{series}{character. (Optional) codes of series matching the 'Series' column of the 'Series' table (retrieved using \code{\link[=series]{series()}}).}

\item{from}{set the start time of the data retrieved by either supplying a start date, a date-string of the form \code{"YYYY-MM-DD"} or \code{"YYYY-MM"},
year-quarters of the form \code{"YYYYQN"} or \code{"YYYY-QN"}, a numeric year \code{YYYY} (numeric or character), or a fiscal year of the form \code{"YYYY/YY"}. These expressions are converted to a regular date by \code{\link{make_date}}.}

\item{to}{same as \code{from}: to set the time period until which data is retrieved. For expressions that are not full "YYYY-MM-DD" dates, the last day of the period is chosen.}

\item{labels}{logical. \code{TRUE} will also return variable labels along with the series codes.}

\item{wide}{logical. \code{TRUE} calls \code{\link{long2wide}} with default settings on the result. \code{FALSE} returns the data in a long format without missing values (suitable for \code{ggplot2}).}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{expand_date}} on the result.}

\item{ordered}{logical. \code{TRUE} orders the result by 'Date' and further by series (if \code{labels = TRUE}), maintaining the column-order of series in the dataset(s).
\code{FALSE} returns the result in a random order, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string.}

\item{\dots}{further arguments passed to \code{\link{long2wide}} (if \code{wide = TRUE}) or \code{\link{expand_date}} (if \code{expand.date = TRUE}), no conflicts between the two.}
}
\description{
This is the main function of the package to retrieve data from the database. It constructs an SQL query which is sent to the database and returns the data as a \emph{data.table} in R.
}
\details{
If \code{labels = FALSE}, the 'SERIES' table is not joined to the 'DATA' table, and \code{ordered = TRUE} will order datasets and series retrieved in alphabetic order.
If \code{labels = TRUE} data is ordered by series and date within each dataset, preserving the order of columns in the dataset. If multiple datasets are received they are ordered alphabetically according to the 'DSID' column.
}
\examples{
\donttest{
# Return monthly macroeconomic indicators from the year 2000 onwards
get_data("BOU_MMI", from = 2000, wide = FALSE)

# Return wide format with date expanded
get_data("BOU_MMI", from = 2000, expand.date = TRUE)

# Same thing in multiple steps (with additional customization options):
library(magrittr) # Pipe \%>\% operators
get_data("BOU_MMI", from = 2000, wide = FALSE) \%>\% long2wide \%>\% expand_date

# Getting a single series
get_data("BOU_MMI", "M2", 2000)

# Getting daily interest rates and plotting
library(xts)   # Time series class
get_data("BOU_I", from = 2018, wide = FALSE) \%>\%
   long2wide(names_from = "Label") \%>\%
   as.xts \%>\%
   plot(legend.loc = "topleft")
}
}
\seealso{
\code{\link{long2wide}}, \code{\link{expand_date}}, \code{\link{ugatsdb}}
}
