% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{series}
\alias{series}
\title{Retrieve Series Table}
\usage{
series(dsid = NULL, dataset.info = TRUE, ordered = TRUE, return.query = FALSE)
}
\arguments{
\item{dsid}{character. (Optional) id's of datasets matching the 'DSID' column of the 'DATASET' table (retrieved using \code{\link[=datasets]{datasets()}}) for which series information is to be returned.}

\item{dataset.info}{logical. \code{TRUE} returns additional information from the 'DATASET' table about the
datasets in which the series are recorded. \code{FALSE} only returns the raw 'SERIES' table.}

\item{ordered}{logical. \code{TRUE} orders the result in the order data was entered into the database, while \code{FALSE} returns the result in a random order, to the benefit of faster query execution.}

\item{return.query}{logical. \code{TRUE} will not query the database but instead return the constructed SQL query as a character string.}
}
\value{
A \code{\link[data.table]{data.table}} with information about the available time series in the database.
}
\description{
This function pulls and returns a table called 'SERIES' from the database.
}
\details{
The 'SERIES' table gives information about all of the time series in the database. Each series is given a code which is however not unique across datasets (see \code{\link{.IDvars}}).
Each series also has a label describing the series. Further information recorded are the minimum and maximum time coverage, and (optionally) a separate series source and url.
By default \code{dataset.info = TRUE} and the frequency of the data, the date when the dataset containing the series was last updated, the dataset and data source are added to the
'SERIES' table from the 'DATASET' table.

If \code{dataset.info = FALSE}, the 'DATASET' table is not joined to the 'SERIES' table, and \code{ordered = TRUE} only orders the series within each dataset to maintain the column order of series in the source data.
In that case the datasets are returned in alphabetic order of 'DSID', not the order in which they were entered into the 'DATASET' table.
}
\examples{
\donttest{
# By default returns all series with additional information
series()

# Raw series table
series(dataset.info = FALSE)

# Only series in the Monthly Macroeconomic Indicators of the BoU
series("BOU_MMI")
}
}
\seealso{
\code{\link{datasets}}, \code{\link{ugatsdb}}
}
