% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{ukb_icd_keyword}
\alias{ukb_icd_keyword}
\title{Retrieves diagnoses containing a description.}
\usage{
ukb_icd_keyword(description, icd.version = 10)
}
\arguments{
\item{description}{A character vector of one or more keywords to be looked up in the ICD descriptions, e.g., "cardio", c("cardio", "lymphoma"). Each keyword can be a regular expression, e.g. "lymph*".}

\item{icd.version}{The ICD version (or revision) number, 9 or 10. Default = 10.}
}
\description{
Returns a dataframe of ICD code and descriptions for all entries including any supplied keyword.
}
\examples{
ukb_icd_keyword("cardio", icd.version = 10)

}
\seealso{
\code{\link{ukb_icd_diagnosis}}, \code{\link{ukb_icd_code_meaning}}, \code{\link{ukb_icd_prevalence}}
}
