% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukds_download.R
\name{ukds_download}
\alias{ukds_download}
\title{Download datasets from the UK Data Service}
\usage{
ukds_download(file_id, org = getOption("ukds_org"),
  user = getOption("ukds_user"), password = getOption("ukds_password"),
  use = getOption("ukds_use"), reset = FALSE, download_dir = "ukds_data",
  msg = TRUE, convert = TRUE, delay = 5)
}
\arguments{
\item{file_id}{The unique identifier (or optionally a vector of these identifiers).
for the dataset(s) to be downloaded (see details).}

\item{org, user, password}{Your UK Data Service organization, username, and password (see details).}

\item{use}{The number of a 'use of data' you have registered with the UK Data Service (see details).}

\item{reset}{If TRUE, you will be asked to re-enter your organization, username, and password.}

\item{download_dir}{The directory (relative to your working directory) to
which files from the UK Data Service will be downloaded.}

\item{msg}{If TRUE, outputs a message showing which data set is being downloaded.}

\item{convert}{If TRUE, converts downloaded file(s) to .RData format.}

\item{delay}{If the speed of your connection to the UK Data Service is particularly slow, 
\code{ukds_download} may encounter problems.  Increasing the \code{delay} parameter
may help.}
}
\value{
The function returns downloaded files.
}
\description{
\code{ukds_download} provides a programmatic and reproducible means to download datasets 
  from the UK Data Service's data archive
}
\details{
To avoid requiring others to edit your scripts to insert their own organization, email,  
 password, and use or to force them to do so interactively, the default is set to fetch 
 this information from the user's .Rprofile.  Before running \code{ukds_download}, 
 then, you should be sure to add these options to your .Rprofile substituting your 
 info for the example below:

   \code{
       options("ukds_org" = "UK Data Archive",
               "ukds_user" = "ukf0000000000",
               "ukds_password" = "password123!",
               "ukds_use" = "111111")
   }
}
\examples{
\dontrun{
 ukds_download(file_id = c())
}

}
