% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crime-no-location.R
\name{ukc_crime_no_location}
\alias{ukc_crime_no_location}
\title{Crimes without location}
\usage{
ukc_crime_no_location(force, crime_category = NULL, date = NULL)
}
\arguments{
\item{force}{A string containing the name of the police force to return data
for. Must be specified, and is not case sensitive.}

\item{crime_category}{The category of crime to return. Defaults to
returning all crimes. See \code{\link[=ukc_crime_category]{ukc_crime_category()}} for details.
See \code{\link[=ukc_forces]{ukc_forces()}} for details.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}
}
\value{
A tibble with details of crimes without a specific location.
}
\description{
Returns details of crimes that cannot be mapped to a particular location.
Note that the police force must be specified
}
\examples{
\dontrun{
no_location <- ukc_crime_no_location(force = "city-of-london")
}

}
