# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' perform a compound transformation on a vector, including clipping
#'
#' @keywords internal
#' @param x numeric vector
#' @param inner numeric constant
#' @param outer numeric constan
#'
#' @return numeric vector of same length as x, containing outer*clip4(inner*x)
clip4 <- function(x, inner, outer) {
    .Call('_umap_clip4', PACKAGE = 'umap', x, inner, outer)
}

#' compute Euclidean distance between two vectors
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return euclidean norm of x-y
dEuclidean <- function(x, y) {
    .Call('_umap_dEuclidean', PACKAGE = 'umap', x, y)
}

#' compute Euclidean distances
#'
#' @keywords internal
#' @param m matrix with raw data
#'
#' @return dEuclidean norms between first row and all other rows
mdEuclidean <- function(m) {
    .Call('_umap_mdEuclidean', PACKAGE = 'umap', m)
}

#' compute Manhattan distance between two vectors
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return manhattan norm of x-y
dManhattan <- function(x, y) {
    .Call('_umap_dManhattan', PACKAGE = 'umap', x, y)
}

#' compute Manhattan distances
#'
#' @keywords internal
#' @param m matrix with raw data
#'
#' @return dManhattan norms between origin and targets
mdManhattan <- function(m) {
    .Call('_umap_mdManhattan', PACKAGE = 'umap', m)
}

#' compute pearson correlation distance between two vectors
#'
#' Pearson distance is (1-r^2)
#'
#' Important: this function assumes that data has been centered
#' i.e. that mean(x) = mean(y) = 0
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return pearson distance between x and y
dCenteredPearson <- function(x, y) {
    .Call('_umap_dCenteredPearson', PACKAGE = 'umap', x, y)
}

#' compute pearson correlation distances 
#'
#' @keywords internal
#' @param m matrix with raw data
#'
#' @return dCenteredPearson norms between first row and all other rows
mdCenteredPearson <- function(m) {
    .Call('_umap_mdCenteredPearson', PACKAGE = 'umap', m)
}

#' compute cosine dissimilarity between two vectors
#'
#' Note: values output from this function do not satisfy the triangle inequality
#'
#' @keywords internal
#' @param x numeric vector
#' @param y numeric vector
#'
#' @return cosine dissimilarity between x and y
dCosine <- function(x, y) {
    .Call('_umap_dCosine', PACKAGE = 'umap', x, y)
}

#' compute cosine distances
#'
#' @keywords internal
#' @param m matrix with raw data
#'
#' @return dCosine norms between first row and all other rows
mdCosine <- function(m) {
    .Call('_umap_mdCosine', PACKAGE = 'umap', m)
}

