% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryACE}
\alias{umxSummary.MxModel.ACE}
\alias{umxSummaryACE}
\title{umxSummaryACE}
\usage{
umxSummaryACE(model, digits = 2, file = getOption("umx_auto_plot"),
  comparison = NULL, std = TRUE, showRg = FALSE, CIs = TRUE,
  report = c("1", "2", "html"), returnStd = FALSE, extended = FALSE,
  zero.print = ".", ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = do not create plot output}

\item{comparison}{you can run mxCompare on a comparison model (NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (T)}

\item{report}{If "html", then open an html table of the results}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{zero.print}{How to show zeros (".")}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Cholesky model returned by \\code{\link{umxACE}}.
}
\examples{
require(umx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
selDVs = c("bmi1", "bmi2")
mzData <- subset(twinData, ZYG == "MZFF", selDVs)
dzData <- subset(twinData, ZYG == "DZFF", selDVs)
m1 = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryACE(m1)
\dontrun{
umxSummaryACE(m1, file = NA);
umxSummaryACE(m1, file = "name", std = TRUE)
stdFit = umxSummaryACE(m1, returnStd = TRUE);
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxACE}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxE}},
  \code{\link{umxPlotIP}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryCP}}, \code{\link{umxSummaryGxE}},
  \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}

