% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_APA_model_CI}
\alias{umx_APA_model_CI}
\title{umx_APA_model_CI}
\usage{
umx_APA_model_CI(model, cellLabel, prefix = "top.", suffix = "_std",
  digits = 2, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get CIs from}

\item{cellLabel}{the label of the cell to interogate for a CI, e.g. "ai_r1c1"}

\item{prefix}{This submodel to look in (i.e. "top.")}

\item{suffix}{The suffix for algebras ("_std")}

\item{digits}{= 2}

\item{verbose}{= FALSE}
}
\value{
- the CI string, e.g. ".73 [-.2, .98]"
}
\description{
Look up CIs for free parameters in a model, and return as APA-formatted text string
}
\examples{
\dontrun{
umx_APA_model_CI(fit_IP, cellLabel = "ai_r1c1", prefix = "top.", suffix = "_std")
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Misc: \code{\link{umxEval}},
  \code{\link{umx_add_variances}}, \code{\link{umx_apply}},
  \code{\link{umx_default_option}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_object_as_str}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}

