% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_aggregate}
\alias{umx_aggregate}
\title{umx_aggregate}
\usage{
umx_aggregate(formula = DV ~ condition, data = NA, what = c("mean_sd",
  "n"), digits = 2, kable = TRUE)
}
\arguments{
\item{formula}{The aggregation formula. e.g., DV ~ condition}

\item{data}{frame to aggregate}

\item{what}{function to use. Defaults to a built-in "smart" mean (sd)}

\item{digits}{for rounding of results}

\item{kable}{Report as a formatted table? (Default is TRUE)}
}
\value{
- table
}
\description{
R's built-in \code{\link{aggregate}} function is extremely useful and powerful, allowing
xtabs based on a formula. umx_aggregate just tries to make using it a bit easier.
In particular, it has some handy base functions that simplify the task of summarising data
aggregating over some grouping factor. A common use is preparing summary tables.
}
\examples{
aggregate(mpg ~ cyl, FUN = mean, na.rm = TRUE, data = mtcars)
umx_aggregate(mpg ~ cyl, data = mtcars)
umx_aggregate(mpg ~ cyl, data = mtcars, kable = FALSE)
umx_aggregate(cbind(mpg, qsec) ~ cyl, data = mtcars, digits = 3)
t(umx_aggregate(cbind(mpg, qsec) ~ cyl, data = mtcars))
\dontrun{
umx_aggregate(cbind(moodAvg, mood) ~ condition, data = study1)
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umx_apply}}, \code{\link{aggregate}}

Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{umxAPA}}, \code{\link{umxGetParameters}},
  \code{\link{umxSummary}}, \code{\link{umx_APA_pval}},
  \code{\link{umx_print}}, \code{\link{umx_show}},
  \code{\link{umx_time}}, \code{\link{umx}}
}
