% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxHetCor}
\alias{umxHetCor}
\title{Create a matrix of correlations for variables of diverse types (binary, ordinal, continuous)}
\usage{
umxHetCor(data, ML = FALSE, use = c("pairwise.complete.obs",
  "complete.obs"), treatAllAsFactor = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{A \code{\link{data.frame}} of columns for which to compute heterochoric correlations}

\item{ML}{Whether to use Maximum likelihood computation of correlations (default = FALSE)}

\item{use}{How to handle missing data: "complete.obs" (Default), "pairwise.complete.obs"}

\item{treatAllAsFactor}{Whether to treat all columns as factors, whether they are or not.}

\item{verbose}{How much to tell the user about what was done.}
}
\value{
- A matrix of correlations
}
\description{
umxHetCor Helper to return just the correlations from John Fox's polycor::hetcor function
}
\examples{
umxHetCor(mtcars[,c("mpg", "am")])
umxHetCor(mtcars[,c("mpg", "am")], treatAllAsFactor = FALSE, verbose = TRUE)
}
\references{
-
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_long2wide}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx_wide2long}}, \code{\link{umx}}
}
