% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builders.r
\name{umxTwoStage}
\alias{umxTwoStage}
\title{umxTwoStage}
\usage{
umxTwoStage(formula, instruments, data, subset, weights, contrasts = NULL,
  name = "tsls", ...)
}
\arguments{
\item{formula}{The structural equation to be estimated; a regression constant is implied if not explicitly omitted.}

\item{instruments}{A one-sided formula specifying instrumental variables.}

\item{data}{data.frame containing the variables in the model.}

\item{subset}{[optional] vector specifying a subset of observations to be used in fitting the model.}

\item{weights}{[optional] vector of weights to be used in the fitting process;
If specified should be a non-negative numeric vector with one entry for each observation,
to be used to compute weighted 2SLS estimates.}

\item{contrasts}{an optional list. See the contrasts.arg argument of model.matrix.default.}

\item{name}{for the model (defaults to "tsls")}

\item{...}{arguments to be passed down.}
}
\value{
-
}
\description{
umxTwoStage implements 2-stage least squares regression in Structural Equation Modeling.
For ease of learning, the function is modeled closely on the \code{\link[sem]{tsls}}.
}
\details{
The example is a Mendelian Randomization \url{https://en.wikipedia.org/wiki/Mendelian_randomization} 
analysis to show the utility of two-stage regression.
}
\examples{
library(umx)


# ====================================
# = Mendelian randomization analysis =
# ====================================

# Note: in practice: many more subjects are desirable - this just to let example run fast
df = umx_make_MR_data(1000) 
m1 = umxTwoStage(Y ~ X, instruments = ~ qtl, data = df)
coef(m1)
plot(m1)

# Errant analysis using ordinary least squares regression (WARNING this result is CONFOUNDED!!)
m1 = lm(Y ~ X    , data = df); coef(m1) # incorrect .35 effect of X on Y
m1 = lm(Y ~ X + U, data = df); coef(m1) # Controlling U reveals the true 0.1 beta weight
#
#
\dontrun{
df = umx_make_MR_data(1e5) 
m1 = umxTwoStage(Y ~ X, instruments = ~ qtl, data = df)

# ======================
# = Now with sem::tsls =
# ======================
# library(sem) # will require you to install X11
m2 = sem::tsls(formula = Y ~ X, instruments = ~ qtl, data = df)
coef(m1)
coef(m2)
m3 = tsls(formula = Y ~ X, instruments = ~ qtl, data = (df[1, "qtl"] = NA))
}
}
\references{
- Fox, J. (1979) Simultaneous equation models and two-stage least-squares.
In Schuessler, K. F. (ed.) \emph{Sociological Methodology}, Jossey-Bass., 
Greene, W. H. (1993) \emph{Econometric Analysis}, Second Edition, Macmillan.
}
\seealso{
- \code{\link{umxRAM}}, \code{\link[sem]{tsls}}

Other Super-easy helpers: \code{\link{umxEFA}},
  \code{\link{umx}}
}
