% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxGxE_biv.R
\name{umxPlotGxE_biv}
\alias{umxPlotGxE_biv}
\alias{plot.MxModel.GxE_biv}
\title{Plot the results of a GxE univariate test for moderation of ACE components.}
\usage{
umxPlotGxE_biv(x, xlab = NA, location = "topleft", separateGraphs = FALSE,
  ...)
}
\arguments{
\item{x}{A fitted \code{\link{umxGxE_biv}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{...}{Optional additional parameters}
}
\value{
-
}
\description{
Plot GxE results (univariate environmental moderation of ACE components).
Options include plotting the raw and standardized graphs separately, or in a combined panel.
You can also set the label for the x axis (xlab), and choose the location of the legend.
}
\examples{
require(umx)
data(twinData)
\dontrun{
selDVs  = "wt"; selDefs = "ht"
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffix = "")
mzData  = subset(df, zygosity \%in\%  c("MZFF", "MZMM"))
dzData  = subset(df, zygosity \%in\%  c("DZFF", "DZMM", "DZOS"))

m1 = umxGxE_biv(selDVs = selDVs, selDefs = selDefs, 
	dzData = dzData, mzData = mzData, sep = "", dropMissingDef = TRUE)
# Plot Moderation
plot(m1)
umxPlotGxE_biv(m1, xlab = "wt", separateGraphs = TRUE, location = "topleft")
}
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxGxE_biv}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umx}}
}
