% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxDiagnose}
\alias{umxDiagnose}
\title{Diagnose problems in a model - this is a work in progress.}
\usage{
umxDiagnose(model, tryHard = FALSE, diagonalizeExpCov = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to diagnose}

\item{tryHard}{whether I should try and fix it? (defaults to FALSE)}

\item{diagonalizeExpCov}{Whether to diagonalize the ExpCov}
}
\value{
\itemize{
\item helpful messages and perhaps a modified model
}
}
\description{
The goal of this function is to diagnose problems in a model and return suggestions to the user.
It is a work in progress, and of no use as yet.
}
\details{
Best diagnostics are:
\enumerate{
\item observed data variances and means
\item expected variances and means
3 Difference of these?
}

Try
* diagonalizeExpCov diagonal.
* umx_any_ordinal()

more tricky - we should really report the variances and the standardized thresholds.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs = 500)
m1 <- umxRAM("OneFactor", data = myData,
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m1 = mxRun(m1)
umxSummary(m1, show = "std")
umxDiagnose(m1)
}
\references{
\itemize{
\item \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
}
\concept{Teaching and Testing functions}
