% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxLabel}
\alias{umxLabel}
\title{umxLabel: Add labels to a RAM model, matrix, or path}
\usage{
umxLabel(obj, suffix = "", baseName = NA, setfree = FALSE,
  drop = 0, labelFixedCells = TRUE, jiggle = NA, boundDiag = NA,
  verbose = FALSE, overRideExisting = FALSE, name = NULL)
}
\arguments{
\item{obj}{An \code{\link{mxModel}} (RAM or matrix based), \code{\link{mxPath}}, or \code{\link{mxMatrix}}}

\item{suffix}{String to append to each label (might be used to distinguish, say male and female submodels in a model)}

\item{baseName}{String to prepend to labels. Defaults to NA ("")}

\item{setfree}{Whether to label only the free paths (defaults to FALSE)}

\item{drop}{The value to fix "drop" paths to (defaults to 0)}

\item{labelFixedCells}{= TRUE}

\item{jiggle}{How much to jiggle values in a matrix or list of path values}

\item{boundDiag}{Whether to bound the diagonal of a matrix}

\item{verbose}{How much feedback to give the user (default = FALSE)}

\item{overRideExisting}{= FALSE}

\item{name}{Optional new name if given a model. Default (NULL) does not rename model.}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxLabel adds labels to things, be it an: \code{\link{mxModel}} (RAM or matrix based), an \code{\link{mxPath}}, or an \code{\link{mxMatrix}}
This is a core function in umx: Adding labels to paths opens the door to \code{\link{umxEquate}}, as well as \code{\link{omxSetParameters}}
}
\examples{
# ==============================================================
# = Show how OpenMx models are not labeled, and then add labels =
# ==============================================================
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
umxGetParameters(m1) # Default "matrix address" labels, i.e "One Factor.S[2,2]"
m1 = umxLabel(m1)
umxGetParameters(m1, free = TRUE) # Informative labels: "G_to_x1", "x4_with_x4", etc.

# =======================================================================
# = Create a new model, with suffixes added to paths, and model renamed =
# =======================================================================
m2 = umxLabel(m1, suffix= "_male", overRideExisting= TRUE, name = "male")
umxGetParameters(m2, free = TRUE) # suffixes added

# =============================
# = Example Labeling a matrix =
# =============================
a = umxLabel(mxMatrix(name = "a", "Full", 3, 3, values = 1:9))
a$labels
a = umxLabel(mxMatrix(name = "a", "Full", 3, 3, values = 1:9), baseName="bob")
a$labels
# note: labels with "data." in the name are left untouched!
a = mxMatrix(name = "a", "Full", 1,3, labels = c("data.a", "test", NA))
a$labels
umxLabel(a, verbose = TRUE)
umxLabel(a, verbose = TRUE, overRideExisting = FALSE)
umxLabel(a, verbose = TRUE, overRideExisting = TRUE)
}
\references{
- \url{https://www.github.com/tbates/umx}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}},
  \code{\link{umxLatent}}, \code{\link{umxRAM2Ordinal}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
