% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSimplex.R
\name{umxSummarySimplex}
\alias{umxSummarySimplex}
\alias{umxSummary.MxModelSimplex}
\title{Shows a compact, publication-style, summary of a Simplex model.}
\usage{
umxSummarySimplex(model, digits = 2, file = getOption("umx_auto_plot"),
  comparison = NULL, std = TRUE, showRg = FALSE, CIs = TRUE,
  report = c("markdown", "html"), returnStd = FALSE,
  extended = FALSE, zero.print = ".", ...)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = no plot.}

\item{comparison}{you can run mxCompare on a comparison model (default = NULL)}

\item{std}{Whether to standardize the output (default = TRUE)}

\item{showRg}{(T/F) Whether to show the genetic correlations (default = FALSE)}

\item{CIs}{Whether to show Confidence intervals if they exist (default = TRUE)}

\item{report}{If "html", then open an html table of the results (default = 'markdown')}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (default = FALSE)}

\item{zero.print}{How to show zeros (default = ".")}

\item{...}{Other parameters to control model summary}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a fitted Simplex model returned by \code{\link{umxSimplex}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for other umx models here: \code{\link{umxSummary}}.
}
\examples{
\dontrun{
# 4 time model
# Select Data
data(iqdat)
mzData <- subset(iqdat, zygosity == "MZ")
dzData <- subset(iqdat, zygosity == "DZ")
vars = c("IQ_age1", "IQ_age2", "IQ_age3", "IQ_age4")
m1= umxSimplex(selDVs= vars, sep= "_T", dzData= dzData, mzData= mzData, tryHard= "mxTryHard")
umxSummary(m1, file = NA);
}
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
- \code{\link{umxSimplex}}

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEold}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPold}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
\concept{Twin Modeling Functions}
