% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_standardize_ACE}
\alias{umx_standardize_ACE}
\title{umx_standardize_ACE}
\usage{
umx_standardize_ACE(model, ...)
}
\arguments{
\item{model}{an \code{\link{umxACE}} model to standardize}

\item{...}{Other options}
}
\value{
- Standardized ACE \code{\link{umxACE}} model
}
\description{
Standardize an ACE model
}
\examples{
require(umx)
data(twinData)
selDVs = c("bmi1", "bmi2")
mzData <- twinData[twinData$zygosity \%in\% "MZFF", selDVs][1:80,] # 80 pairs for speed
dzData <- twinData[twinData$zygosity \%in\% "DZFF", selDVs][1:80,]
m1  = umxACE(selDVs = selDVs, dzData = dzData, mzData = mzData)
std = umx_standardize_ACE(m1)
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other zAdvanced Helpers: \code{\link{umx_merge_CIs}},
  \code{\link{umx_standardize_ACEcov}},
  \code{\link{umx_standardize_ACEv}},
  \code{\link{umx_standardize_CP}},
  \code{\link{umx_standardize_IP}},
  \code{\link{umx_standardize_SexLim}},
  \code{\link{umx_standardize_Simplex}},
  \code{\link{umx_stash_CIs}}, \code{\link{umx}}
}
\concept{zAdvanced Helpers}
