% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxPlotGxE}
\alias{umxPlotGxE}
\alias{plot.MxModel.GxE}
\title{Plot the results of a GxE univariate test for moderation of ACE components.}
\usage{
umxPlotGxE(x, xlab = NA, location = "topleft", separateGraphs = FALSE,
  ...)
}
\arguments{
\item{x}{A fitted \code{\link{umxGxE}} model to plot}

\item{xlab}{String to use for the x label (default = NA, which will use the variable name)}

\item{location}{Where to plot the legend (default = "topleft")
see ?legend for alternatives like bottomright}

\item{separateGraphs}{(default = FALSE)}

\item{...}{Optional additional parameters}
}
\value{
-
}
\description{
Plot GxE results (univariate environmental moderation of ACE components).
Options include plotting the raw and standardized graphs separately, or in a combined panel.
You can also set the label for the x axis (xlab), and choose the location of the legend.
}
\examples{
require(umx)
data(twinData) 
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, zyg == 1, selVars)
dzData  = subset(twinData, zyg == 3, selVars)
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, 
 	dzData = dzData, mzData = mzData, dropMissing = TRUE)
plot(m1)
umxPlotGxE(x = m1, xlab = "SES", separateGraphs = TRUE, location = "topleft")
}
\references{
- \url{http://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxGxE}}

Other Plotting functions: \code{\link{plot.MxModel}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotACEv}},
  \code{\link{umxPlotACE}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE_biv}}, \code{\link{umxPlotIP}},
  \code{\link{umx}}
}
