% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_make_fake_data}
\alias{umx_make_fake_data}
\title{umx_make_fake_data}
\usage{
umx_make_fake_data(
  dataset,
  digits = 2,
  n = NA,
  use.names = TRUE,
  use.levels = TRUE,
  use.miss = TRUE,
  mvt.method = "eigen",
  het.ML = FALSE,
  het.suppress = TRUE
)
}
\arguments{
\item{dataset}{The original dataset of which to make a simulacrum}

\item{digits}{= Round the data to the requested digits (default = 2)}

\item{n}{Number of rows to generate (NA = all rows in dataset)}

\item{use.names}{Whether to name the variables (default = TRUE)}

\item{use.levels}{= Whether to use existing levels (default = TRUE)}

\item{use.miss}{Whether to have data missing as in original (defaults to TRUE)}

\item{mvt.method}{= Passed to hetcor (default = "eigen")}

\item{het.ML}{= Passed to hetcor (default = FALSE)}

\item{het.suppress}{Passed to hetcor (default = TRUE)}
}
\value{
- new dataframe
}
\description{
This function takes as argument an existing dataset, which 
must be either a matrix or a data frame. Each column of the 
dataset must consist either of numeric variables or ordered 
factors. When one or more ordered factors are included, 
then a heterogeneous correlation matrix is computed using 
John Fox's polycor package. Pairwise complete observations 
are used for all covariances, and the exact pattern of 
missing data present in the input is placed in the output,
provided a new sample size is not requested. Warnings from
the polycor::hetcor function are suppressed.
}
\examples{
fakeCars = umx_make_fake_data(mtcars)
}
\seealso{
[OpenMx::mxGenerateData()]

Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
