% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxPlotACE}
\alias{umxPlotACE}
\alias{plot.MxModelACE}
\title{Make a graphical display of an ACE model}
\usage{
umxPlotACE(
  x = NA,
  file = "name",
  digits = 2,
  means = FALSE,
  std = TRUE,
  strip_zero = TRUE,
  showFixed = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{\link[=mxModel]{mxModel()}} to plot (created by umxACE in order to inherit the MxModelACE class)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (default is 2)}

\item{means}{Whether to show means paths (default is FALSE)}

\item{std}{Whether to standardize the model (default is TRUE)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{showFixed}{Whether too draw fixed parameters.}

\item{...}{Additional (optional) parameters}
}
\value{
\itemize{
\item optionally return the dot code
}
}
\description{
plot method for \code{\link[=umxACE]{umxACE()}} models. Make a graphical display of an ACE model
}
\examples{
\dontrun{
require(umx)
data(twinData)
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "DZFF")
m1 = umxACE("plotACE example", selDVs = "bmi", dzData = dzData, mzData = mzData, sep = "")
plot(m1, std = FALSE) # don't standardize
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

\itemize{
\item \code{\link[=umxACE]{umxACE()}}
}

Other Plotting functions: 
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotDoC}()},
\code{\link{umxPlotFun}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umx}}
}
\concept{Plotting functions}
