% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxMRDoC.R
\name{umxMRDoC}
\alias{umxMRDoC}
\title{Extends Mendelian randomization with the twin design to test evidence of causality}
\usage{
umxMRDoC(
  pheno,
  prss,
  mzData = NULL,
  dzData = NULL,
  data = NULL,
  zyg = NULL,
  sep = "_T",
  summary = !umx_set_silent(silent = TRUE),
  name = NULL,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{pheno}{Phenotypes of interest, order matters ("exposure", "outcome")}

\item{prss}{Polygenic score(s). If a single one is passed MRDoC is run, MRDoC2 otherwise.}

\item{mzData}{The MZ dataframe}

\item{dzData}{The DZ dataframe}

\item{data}{= NULL If building the MZ and DZ datasets internally from a complete data set.}

\item{zyg}{= "zygosity" (for the data= method of using this function)}

\item{sep}{The separator in twin variable names, default = "_T", e.g. "dep_T1".}

\item{summary}{Optionally show a summary.}

\item{name}{The name of the model (defaults to either "MRDoC" or "MRDoC2).}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing).}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}} of subclass MxModelMRDoC
}
}
\description{
Testing causal claims is often difficult due to an inability to conduct experimental randomization of traits and
situations to people. When twins are available, even when measured on a single occasion, the pattern of cross-twin
cross-trait correlations can (given distinguishable modes of inheritance for the two traits) falsify causal hypotheses.

\code{umxMRDoC} implements a 2-group model to form latent variables for each of two traits, and allows testing whether
trait 1 causes trait 2, vice-versa, or even reciprocal causation. This is robust to several types of confounding
due to the instrumental variable approach included in the model.

This function applies both the MRDoC model and the MRDoC2 model depending on how many PRSs are passed as arguments.
}
\examples{
\dontrun{

# ================
# = 1. Load Data =
# ================
data(docData)
mzData  = subset(docData, zygosity \%in\% c("MZFF", "MZMM"))
dzData  = subset(docData, zygosity \%in\% c("DZFF", "DZMM"))

# ============================
# = 2. Make a MRDoC2 model   =
# ============================
out = umxMRDoC(mzData = mzData, dzData = dzData,  
pheno = c("varA1", "varA2"), prss = c("varB1", "varA3") )
}
}
\references{
\itemize{
\item Minica CC, Dolan CV, Boomsma DI, et al. (2018) Extending Causality Tests with Genetic Instruments: An Integration of Mendelian Randomization with the Classical Twin Design. Behavior Genetics 48(4): 337–349. \doi{10.1007/s10519-018-9904-4}
}
\itemize{
\item McGue, M., Osler, M., & Christensen, K. (2010). Causal Inference and Observational Research: The Utility of Twins. \emph{Perspectives on Psychological Science}, \strong{5}, 546-556. \doi{10.1177/1745691610383511}
\item Castro-de-Araujo LFS, Singh M, Zhou Y, et al. (2022) MR-DoC2: Bidirectional Causal Modeling with Instrumental Variables and Data from Relatives. Behavior Genetics. \doi{10.1007/s10519-022-10122-x}
}
}
\seealso{
\itemize{
\item \code{\link[=umxDoC]{umxDoC()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoCp}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxReduce}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
