% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iqdat}
\alias{iqdat}
\title{Twin data: IQ measured longitudinally across 4 ages.}
\format{
A data frame with 562 rows (twin families). Nine measures on each twin.
}
\usage{
data(iqdat)
}
\description{
Measures of IQ across four ages in 261 pairs of identical twins and 301 pairs of fraternal (DZ) twins. (see details).
It is used as data for the [umxSimplex()] examples.
}
\details{
\itemize{
  \item zygosity Zygosity (MZ or DZ)
  \item IQ_age1_T1 T1 IQ measured at age 1
  \item IQ_age2_T1 T1 IQ measured at age 2
  \item IQ_age3_T1 T1 IQ measured at age 3
  \item IQ_age4_T1 T1 IQ measured at age 4
  \item IQ_age1_T2 T2 IQ measured at age 1
  \item IQ_age2_T2 T2 IQ measured at age 2
  \item IQ_age3_T2 T2 IQ measured at age 3
  \item IQ_age4_T2 T2 IQ measured at age 4
}
}
\examples{
data(iqdat)
str(iqdat)
par(mfrow = c(1, 3))  # 1 rows and 3 columns
plot(IQ_age4_T1 ~ IQ_age4_T2, ylim = c(50, 150), data = subset(iqdat, zygosity == "MZ"))
plot(IQ_age4_T1 ~ IQ_age4_T2, ylim = c(50, 150), data = subset(iqdat, zygosity == "DZ"))
plot(IQ_age1_T1 ~ IQ_age4_T2, data = subset(iqdat, zygosity == "MZ"))
par(mfrow = c(1, 1))  # back to as it was
}
\references{
Boomsma, D. I., Martin, N. G., & Molenaar, P. C. (1989). Factor and simplex models for repeated measures: 
application to two psychomotor measures of alcohol sensitivity in twins. *Behavior Genetics*, **19**, 79-96.
Retrieved from <https://www.ncbi.nlm.nih.gov/pubmed/2712815>
}
\seealso{
[umxSimplex()]

Other datasets: 
\code{\link{Fischbein_wt}},
\code{\link{GFF}},
\code{\link{docData}},
\code{\link{umx}},
\code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
