% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxMatrixFree.R
\name{umxMatrixFree}
\alias{umxMatrixFree}
\title{Sets labeled matrix cells to free}
\usage{
umxMatrixFree(
  name = name,
  nrow = NULL,
  ncol = NA,
  free = FALSE,
  values = NA,
  labels = labels,
  byrow = TRUE,
  ...
)
}
\arguments{
\item{name}{The name of the matrix: Must be set}

\item{nrow}{Number of rows in the matrix (Optional)}

\item{ncol}{Number of columns in the matrix (Required)}

\item{free}{Whether cells are free (Default FALSE)}

\item{values}{The values of the matrix (Default NA)}

\item{labels}{The labels of the matrix (Default NA)}

\item{byrow}{Default for byrow (TRUE)}

\item{...}{Accepts all other arguments from \code{\link[=umxMatrix]{umxMatrix()}}}
}
\value{
\itemize{
\item \code{\link[OpenMx:mxMatrix]{OpenMx::mxMatrix()}}
}
}
\description{
In simulation studies, it is often necessary to rewrite the matrices while testing
alternative specifications. This can become very tedious with increasing
number of distinct specifications. This tool injects changes into umxMatrix so
that this tasks gets more manageable. First, it sets byRow by default. Second,
it infers the number of rows automatically. The user needs only passing ncol.
Finally and most importantly this function disables auto-labeling, and whenever
a label is set, that cell position will be freed. It is required to pass
a matrix of labels, as well as a label name.
}
\examples{
\dontrun{

umxMatrixFree('E', type='Symm',  ncol = 3,
  labels =c("eb2",NA,NA,
             NA,"es2",NA,
            NA,NA,NA),
  values=c(.2,0,0,
           0,.2,0,
           0,0,0))
           
 # Will return a umxMatrix free at the eb2 and es2 positions.
}
}
\seealso{
\itemize{
\item \code{\link[=umxMatrix]{umxMatrix()}}
}
}
