% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxPower.R
\name{umxPower}
\alias{umxPower}
\title{Test power to detect specified path values in a model.}
\usage{
umxPower(
  trueModel,
  update = NULL,
  n = NULL,
  power = NULL,
  sig.level = 0.05,
  value = 0,
  method = c("ncp", "empirical"),
  explore = FALSE,
  digits = 2,
  plot = FALSE,
  silent = TRUE
)
}
\arguments{
\item{trueModel}{The model with the parameters at values you expect in the population.}

\item{update}{The parameter(s) to drop}

\item{n}{How many subjects? (Default = NULL)}

\item{power}{Default = NULL (conventional level = .8)}

\item{sig.level}{Default = .05}

\item{value}{Value of dropped parameter (default = 0)}

\item{method}{"ncp" (default) or "empirical"}

\item{explore}{Whether to tabulate the range of n or effect size (if n specified). Default = FALSE.}

\item{digits}{Rounding precision for reporting result.}

\item{plot}{whether to plot the power.}

\item{silent}{Suppress model runs printouts to console (TRUE)}
}
\value{
power table
}
\description{
\code{umxPower} takes an input model (the model of the true data), and tests power (or determines n)
to detect dropping (or changing the value) a path in this true model.

A typical target for power is 80\%. Much as the accepted critical p-value is .05, this has emerged as a trade off, in this case
of resources required for more powerful studies against the cost of missing a true effect.  People interested in truth
discourage running studies with low power: A study with 20 percent power will fail to detect real effects 80\% of the time.
But even with zero power, the Type-I error rate remains a nominal 5\% (and with any researcher degrees of freedom, perhaps much more than that).
Low powered research, then, fails to detect true effects, and generates support for random false theories about as often.
This sounds silly, but empirical rates are often as low as 20\% (Button, et al., 2013).

Illustration of  \eqn{\alpha}, \eqn{\beta}, and power (1-\eqn{\beta}):

\if{html}{\figure{power.png}{options: width="50\%" alt="Figure: power.png"}}
\if{latex}{\figure{power.pdf}{options: width=7cm}}
}
\examples{
# ===================================================
# = Power to detect correlation of .3 in 200 people =
# ===================================================

# 1 Make some data
tmp = umx_make_raw_from_cov(qm(1, .3| .3, 1), n=2000, varNames= c("X", "Y"), empirical= TRUE)

# 2. Make model of true XY correlation of .3
m1 = umxRAM("corXY", data = tmp,
   umxPath("X", with = "Y"),
   umxPath(var = c("X", "Y"))
)
# 3. Test power to detect .3 versus 0, with n= 90 subjects
umxPower(m1, "X_with_Y", n= 90)

# ####################
# # Estimating power #
# ####################
# 
#    method = ncp
#         n = 90
#     power = 0.83
# sig.level = 0.05
# statistic = LRT

# =================================================
# = Tabulate Power across a range of values of  n =
# =================================================
umxPower(m1, "X_with_Y", explore = TRUE)

\dontrun{

# =====================================
# = Examples with method = empirical  =
# =====================================

# Power to detect r = .3 given n=90
umxPower(m1, "X_with_Y", n = 90, method = "empirical")
# power is .823
# Test using cor.test doing the same thing.
pwr::pwr.r.test(r = .3, n = 90)
#           n = 90
#           r = 0.3
#   sig.level = 0.05
#       power = 0.827
# alternative = two.sided

# Power search for detectable effect size, given n = 90
umxPower(m1, "X_with_Y", n= 90, method = "empirical", explore = TRUE)

# Search X_with_Y:power relationship for n=90
# |    | X_with_Y | power | lower | upper |
# |:---|:---------|:------|:------|:------|
# | 1  | 0.03     | 0.27  | 0.15  | 0.44  |
# | 2  | 0.03     | 0.32  | 0.20  | 0.48  |
# | 3  | 0.04     | 0.38  | 0.26  | 0.53  |
# | 4  | 0.04     | 0.45  | 0.33  | 0.57  |
# | 5  | 0.04     | 0.51  | 0.41  | 0.61  |
# | 6  | 0.05     | 0.58  | 0.49  | 0.66  |
# | 7  | 0.05     | 0.64  | 0.57  | 0.71  |
# | 8  | 0.06     | 0.70  | 0.64  | 0.75  |
# | 9  | 0.06     | 0.75  | 0.69  | 0.80  |
# | 10 | 0.06     | 0.80  | 0.74  | 0.85  |
# | 11 | 0.07     | 0.84  | 0.77  | 0.88  |
# | 12 | 0.07     | 0.87  | 0.80  | 0.92  |
# | 13 | 0.08     | 0.90  | 0.83  | 0.94  |
# | 14 | 0.08     | 0.92  | 0.85  | 0.96  |
# | 15 | 0.08     | 0.94  | 0.87  | 0.97  |
# | 16 | 0.09     | 0.95  | 0.89  | 0.98  |
# | 17 | 0.09     | 0.96  | 0.91  | 0.98  |
# | 18 | 0.10     | 0.97  | 0.92  | 0.99  |
# | 19 | 0.10     | 0.98  | 0.93  | 0.99  |
# | 20 | 0.10     | 0.98  | 0.94  | 0.99  |

}

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}
}
}
\seealso{
\itemize{
\item \code{\link[=umxRAM]{umxRAM()}}
}

Other Teaching and Testing functions: 
\code{\link{tmx_show}()},
\code{\link{umxDiagnose}()}
}
\concept{Teaching and Testing functions}
