% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{diameter}
\alias{diameter}
\title{Diameter}
\usage{
diameter(file_path, signavio = FALSE, path_log_already_created = FALSE,
  generate_new_path_log = FALSE, time_to_generate_path_log = 1500)
}
\arguments{
\item{file_path}{document object created using the create_internal_document function}

\item{signavio}{boolean which indicates whether the file stems from signavio}

\item{path_log_already_created}{boolean which indicates whether the path log has already been created before or not. When you are not sure, it is best to use the standard which is false}

\item{generate_new_path_log}{used when it is not possible to save the path log such as with the Rapid miner or in unit tests and examples}

\item{time_to_generate_path_log}{time which is the maximum time to generate a new path log in seconds. The standard setting is 1500 seconds.}
}
\value{
an integer indicating the diameter
}
\description{
Length of longest path, in practice the length of longest path.
The assumption is made that one repetition for each loop is allowed and these repetitions count as well for the diameter
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")}
diameter(file_path, generate_new_path_log = TRUE)
}
