% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Behavioral_profile.R
\name{traces_contain_relation}
\alias{traces_contain_relation}
\title{Relation in traces}
\usage{
traces_contain_relation(repetition_and_path_log, xml_internal_doc, activity_1,
  activity_2, always = TRUE, filter_indirect = TRUE, precede = FALSE,
  alternate_response = FALSE, alternate_precedence = FALSE,
  chain_response = FALSE, chain_precedence = FALSE,
  negation_alternate_precedence = FALSE,
  negation_alternate_response = FALSE)
}
\arguments{
\item{repetition_and_path_log}{repetition and path log list object created by the function create_repetition_and_path_log}

\item{xml_internal_doc}{document object created using the create_internal_document function}

\item{activity_1}{the activity name of the first activity}

\item{activity_2}{the activity name of the second activity in the relation}

\item{always}{a boolean value indicating whether there should be always a direct relation. If it is false, it is assumed to be tested for the sometimes case.}

\item{filter_indirect}{a boolean value indicating whether indirect relations are targeted. If not, all relations are used}

\item{precede}{a boolean value indicating whether precede or follows relation is tested}

\item{alternate_response}{a boolean indicating whether an alternate response relation is tested}

\item{alternate_precedence}{a boolean indicating whether an alternate precedence relation is tested}

\item{chain_response}{a boolean indicating whether a chain response relation is tested}

\item{chain_precedence}{a boolean indicating whether a chain precedence relation is tested}

\item{negation_alternate_precedence}{a boolean indicating whether a negation alternate precedence relation is tested}

\item{negation_alternate_response}{a boolean indicating whether a negation alternate response relation is tested}
}
\value{
a boolean value indicating whether it is true that there is always or sometimes an indirect relation between activity_1 and activity_2
}
\description{
{ This functions returns true or false on whether there exists always or sometimes an (indirect) relation between two activities in a process model.
This can be useful for measuring the understandability using behavioral profiles. Always means that wheneve activity 1 is part of the trace, activity 2 will some time follow activity 1.
Sometimes means that there should be at least one case where there is an indirect relation and at least one case where there is not.
The indirect relations between two activities due to a parallel construct are left out of scope for this function.
}
}
\examples{
\dontrun{traces_contain_relation(log, doc, "A", "F", TRUE, TRUE)}
}
