% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex_valign.R
\name{regex_valign}
\alias{regex_valign}
\title{Vertical character string alignment through regular expressions}
\usage{
regex_valign(stringvec, regex_ai, sep_str = "")
}
\arguments{
\item{stringvec}{A character vector with one element for each line.}

\item{regex_ai}{A regular expression matching the position for alignment.}

\item{sep_str}{Optional character vector that will be inserted at the
positions matched by the regular expression.}
}
\value{
A character vector with one element for each line, with padding
inserted at the matched positions so that elements are vertically aligned
across lines.
}
\description{
Aligning strings with regex.
}
\details{
Written mainly for reading fixed width files, text, or tables parsed
from PDFs.
}
\examples{
guests <-
  unlist(strsplit(c("6       COAHUILA        20/03/2020
7       COAHUILA             20/03/2020
18 BAJA CALIFORNIA     16/03/2020
109       CDMX      12/03/2020
1230   QUERETARO       21/03/2020"), "\n"))

# align at first uppercase word boundary , inserting a separator
regex_valign(guests, "\\\\b(?=[A-Z])", " - ")
# align dates at end of string
regex_valign(guests, "\\\\b(?=[0-9]{2}[\\\\/]{1}[0-9]{2}[\\\\/]{1}[0-9]{4}$)")
}
\seealso{
This function is based loosely on
\code{textutils::valign()}.
}
