% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McGill.R
\docType{data}
\name{mcgill_darks}
\alias{mcgill_darks}
\title{Dark colours of McGill University, Canada}
\format{
An object of class \code{character} of length 7.
}
\source{
Colour definitions are based on the
\href{https://www.mcgill.ca/visual-identity/visual-identity-guide}{Visual Identity Guide}.
}
\usage{
mcgill_darks
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
McGill’s secondary colours, are not official but rather suggested colours that cover a larger spectrum to complement the McGill red.
They can be used to add variety and contrast for headings, bullets, background and other graphic elements.
}
\details{
\code{mcgill_darks} provides the dark colours 
of \href{https://www.mcgill.ca/}{McGill University}, Canada.

The muted colours are 
\code{"dark_1"} (defined as CMYK 0/72/75/35, RGB 170/75/49, HEX #AA4B31),
\code{"dark_2"} (defined as CMYK 35/45/100/0, RGB 178/140/53, HEX #B28C35),
\code{"dark_3"} (defined as CMYK 90/45/53/23, RGB 10/98/102, HEX #0A6266),
\code{"dark_4"} (defined as CMYK 97/66/38/20, RGB 2/79/109, HEX #024F6D),
\code{"dark_5"} (defined as CMYK 78/42/86/40, RGB 48/85/52, HEX #305534),
\code{"dark_6"} (defined as CMYK 65/90/31/18, RGB 103/53/103, HEX #673567), and
\code{"dark_7"} (defined as CMYK 0/100/90/40, RGB 158/9/24, HEX #9E0918).

\code{mcgill_darks} uses the HEX colour definitions.
 
Note that the CMYK colour values differ from RGB and HEX definitions.
}
\examples{
mcgill_darks
unikn::seecol(mcgill_darks, main = "Dark colours of McGill") # view colour palette

}
\seealso{
\code{\link{mcgill_red}} for the primary colour of McGill University; 
\code{\link{mcgill_pastels}} for the pastel colours of McGill;
\code{\link{mcgill_brights}} for the bright colours of McGill;
\code{\link{mcgill_muted}} for the muted colours of McGill;
\code{\link{mcgill_grey}} for the grey of McGill;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
