% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dundee.R
\docType{data}
\name{dundee_core}
\alias{dundee_core}
\title{Core colours of University of Dundee, Scotland}
\format{
An object of class \code{character} of length 1.
}
\source{
Colour definitions are based on \href{https://www.dundee.ac.uk}{Dundee}'s 
\href{https://www.app.dundee.ac.uk/pattern-library/}{Brand colour palette}.
}
\usage{
dundee_core
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{dundee_core} provides the core colour 
of \href{https://www.dundee.ac.uk}{University of Dundee}, Scotland, UK.
}
\details{
The core colour is 
\code{Dundee core} (defined as PANTONE 2726C, CMYK 83/67/0/0, RGB 67/101/226, HEX #4365e2). 
\code{Dundee core} uses the HEX colour definition. 
Note that Pantone and CMYK colours differ from the RGB and HEX definition.


The central blue core colour is at the heart of 
\href{https://www.dundee.ac.uk}{Dundee}'s identity. 

The University shield and wordmark can be reproduced in the core colour 
and it can also be applied to icons and typography.

See \code{\link{dundee_background}} for 
\href{https://www.dundee.ac.uk}{Dundee}'s background colour.
}
\examples{
dundee_core
unikn::seecol(dundee_core, col_bg = unikn::usecol(dundee_background),  
              main = "Core colour of Dundee, Scotland")  # view colour 

}
\seealso{
\code{\link{dundee_highlight}} for the highlight colours of University of Dundee;
\code{\link{dundee_block}} for the block colours of University of Dundee;
\code{\link{dundee_background}} for the background colour of University of Dundee;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stirling_1}},
\code{\link{stirling_2}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-06-22.
}
\concept{Scottish university color palettes}
\keyword{datasets}
