% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copenhagen.R
\docType{data}
\name{ku_2}
\alias{ku_2}
\title{Secondary colours of the University of Copenhagen, Denmark}
\format{
An object of class \code{character} of length 18.
}
\source{
Color definitions are based on \href{https://www.ku.dk}{KU}'s 
\href{https://designguide.ku.dk/om_design/logo_og_farve/farver/}{design guide} (HTML).
}
\usage{
ku_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ku_2} provides eighteen secondary colours 
of the \href{https://www.ku.dk}{University of Copenhagen}, Denmark.
}
\details{
The 18 secondary colours are structured into 6 hues in 3 tints. 

\code{ku_2} is based on HEX color definitions.
}
\examples{
ku_2
unikn::seecol(ku_2, 
              main = "Secondary colours of the University of Copenhagen, DK")  # view palette
              
}
\seealso{
\code{\link{ku_1}} for primary colours of the University of Copenhagen;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Danish university color palettes: 
\code{\link{aarhus}},
\code{\link{ku_1}}
}
\author{
\strong{unicol}, 2023-10-13.
}
\concept{Danish university color palettes}
\keyword{datasets}
