% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCIrvine.R
\docType{data}
\name{uci_4}
\alias{uci_4}
\title{Secondary colors of UCI Health, Irvine, USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on \href{https://www.uci.edu}{UCIrvine}'s 
\href{https://brand.uci.edu/master-branding/color-palette/}{brand guide}.
}
\usage{
uci_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uci_4} provides 5 neutral colors
of the \href{https://www.uci.edu}{University of California, Irvine}, USA, 
that are used as the secondary colors of \href{https://www.ucihealth.org}{UCI Health}.
}
\details{
The 5 colors are 
\code{"brick red"} (defined as HEX #981e32),
\code{"purple"} (defined as HEX #631d76),
\code{"teal blue"} (defined as HEX #0083b3),
\code{"green"} (defined as HEX #3f9c35), and 
\code{"dark blue"} (defined as HEX #1b3d6d).

\code{uci_4} uses the HEX color definitions.


Only to be used in patient-facing material.
}
\examples{
uci_4
unikn::seecol(uci_4, main = "Secondary colors of UCI Health")  # view color palette

}
\seealso{
\code{\link{uci_1}} for primary colors of UC Irvine;
\code{\link{uci_2}} for secondary colors of UC Irvine;
\code{\link{uci_3}} for tertiary colors of UC Irvine;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-07-13.
}
\concept{U.S. university color palettes}
\keyword{datasets}
