% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{add_prop}
\alias{add_prop}
\title{Add a prop to a unifir script}
\usage{
add_prop(script, prop, exec = TRUE)
}
\arguments{
\item{script}{A script object (from \link{make_script}) to append the prop to.}

\item{prop}{A \code{unifir_prop} object (from \link{unifir_prop}) to add to the script.}

\item{exec}{Logical: Should the method created by the prop be called in the
MainFunc method?}
}
\description{
This function is exported so that developers can add their own props
in new packages, without needing to re-implement the prop and script
classes themselves. It is not expected that end users will need this
function.
}
\examples{
script <- make_script("example_script", unity = waiver())
prop <- unifir_prop(
  prop_file = waiver(), # Must be a file that exists or waiver()
  method_name = NULL, # Auto-generated if NULL or NA
  method_type = "ExampleProp", # Length-1 character vector
  parameters = list(), # Not validated, usually a list
  build = function(script, prop, debug) {},
  using = character(0)
)
script <- add_prop(script, prop)
}
\seealso{
Other props: 
\code{\link{add_default_player}()},
\code{\link{add_light}()},
\code{\link{add_texture}()},
\code{\link{create_terrain}()},
\code{\link{import_asset}()},
\code{\link{instantiate_prefab}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()}

Other utilities: 
\code{\link{add_default_player}()},
\code{\link{create_unity_project}()},
\code{\link{find_unity}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{props}
\concept{utilities}
