% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_themes.R
\name{theme_grau}
\alias{theme_grau}
\title{Alternative theme for ggplot2.}
\usage{
theme_grau(
  col_title = grey(0, 1),
  base_size = 11,
  base_family = "",
  base_line_size = base_size/20,
  base_rect_size = base_size/20
)
}
\arguments{
\item{col_title}{Color of title (text) elements (optional, numeric).
Default: \code{col_title = grey(0, 1)} (i.e., "black").  
Consider using \code{col_title = unikn::pal_seeblau[[4]]}.}

\item{base_size}{Base font size (optional, numeric). 
Default: \code{base_size = 11}.}

\item{base_family}{Base font family (optional, character). 
Default: \code{base_family = ""}.}

\item{base_line_size}{Base line size (optional, numeric). 
Default: \code{base_line_size = base_size/20}.}

\item{base_rect_size}{Base rectangle size (optional, numeric). 
Default: \code{base_rect_size = base_size/20}.}
}
\description{
\code{theme_grau} provides an alternative \bold{unikn} theme 
to use in \bold{ggplot2} commands.
}
\details{
\code{theme_grau} is no-nonsense, but fills  
panel backgrounds in "grau" (specifically, pal_seeggrau[[1]]). 

This theme works well for dark colors and bright color accents, 
but is of limited use with transparent colors.
}
\examples{

\donttest{
  # Plotting iris dataset (using ggplot2, theme_unikn, and unikn colors):
  
  library("ggplot2")  # theme_unikn requires loading ggplot2 
  
  ggplot(datasets::iris) +
    geom_jitter(aes(x = Petal.Length, y = Petal.Width, color = Species), size = 3, alpha = 2/3) +
    scale_color_manual(values = usecol(pal = c(Seeblau, Bordeaux, Petrol))) +
    labs(title = "Iris species",
         caption = "Data from datasets::iris") + 
    theme_grau(base_size = 11)
}

}
\seealso{
\code{\link{theme_unikn}} for default theme.

Other plot functions: 
\code{\link{slide}()},
\code{\link{theme_unikn}()},
\code{\link{xbox}()}
}
\concept{plot functions}
