% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niters.R
\name{niters}
\alias{niters}
\title{Number of Iterations}
\usage{
niters(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer scalar of the number of iterations.
}
\description{
Gets the number of iterations (in a chain)
of an MCMC object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

niters(nlist(x = 1:2))
niters(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
\dontshow{\}) # examplesIf}
}
\seealso{
Other MCMC dimensions: 
\code{\link{nchains}()},
\code{\link{npars}()},
\code{\link{nsams}()},
\code{\link{nsims}()},
\code{\link{nterms}()}
}
\concept{MCMC dimensions}
