% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-period.R
\docType{class}
\name{Periods}
\alias{Periods}
\title{Set a Period and Get its Time Interval}
\description{
Set a Period and Get its Time Interval

Set a Period and Get its Time Interval
}
\details{
An Object of \code{\link{R6Class}} with methods to set
common time periods and specifications for time periods.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.interval}}{Stores a time interval.}

\item{\code{fuzzy}}{Either `-1` (approximate) or `1` (uncertain).}

\item{\code{express}}{Either `-1` (before) or `1` (after).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.interval}}{Stores a time interval.}

\item{\code{interval}}{Convert and return a POSIXt time interval.}

\item{\code{time_span}}{Convert and return a time span in years.}

\item{\code{iso_format}}{Convert and return a date in ISO 8601.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Periods$new()}}
\item \href{#method-set_additions}{\code{Periods$set_additions()}}
\item \href{#method-take}{\code{Periods$take()}}
\item \href{#method-clone}{\code{Periods$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Helper function to specify a time period.


Create a time period.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Periods$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Intervals, numerical scalars, or objects of
class \code{Period}.}

\item{\code{x}}{A numerical scalar. The range of valid values
depends on \code{type}. If \code{type} is \code{"early"},
\code{"mid"}, or \code{"late"}, \code{x} is ignored.}

\item{\code{type}}{A character scalar. The following values
are supported: \code{"early"}, \code{"mid"}, \code{"late"},
\code{"quarter"}, \code{"third"}, and \code{"half"}. If
\code{type} is `NULL`, \code{x} defines a year or decade.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_additions"></a>}}
\if{latex}{\out{\hypertarget{method-set_additions}{}}}
\subsection{Method \code{set_additions()}}{
Set additions for a time period.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Periods$set_additions(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A character vector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-take"></a>}}
\if{latex}{\out{\hypertarget{method-take}{}}}
\subsection{Method \code{take()}}{
Specify a period.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Periods$take(x = NA, type = NA, ignore_errors = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numerical scalar. The range of valid values
depends on \code{type}. If \code{type} is \code{"early"},
\code{"mid"}, or \code{"late"}, \code{x} is ignored.}

\item{\code{type}}{A character scalar. The following values
are supported: \code{"early"}, \code{"mid"}, \code{"late"},
\code{"quarter"}, \code{"third"}, and \code{"half"}. If
\code{type} is `NULL`, \code{x} defines a year or decade.}

\item{\code{ignore_errors}}{If `TRUE`, error messages are ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of \code{\link{R6Class}} with methods to set
common time periods and specifications for time periods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Periods$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
