% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.hp.r
\name{upset.hp}
\alias{upset.hp}
\title{Visualization of VP and HP Using UpSet Diagram}
\usage{
upset.hp(
  vp,
  hp,
  plot.hp = TRUE,
  order.part = "effect",
  decreasing.part = TRUE,
  order.var = TRUE,
  decreasing.var = TRUE,
  cutoff = -1,
  nVar = 30,
  col.width = 0.6,
  pch.size = 3,
  line.lwd = 0.5,
  show.effect = TRUE,
  effect.cex = 2.7,
  title.cex = 10,
  axis.cex = 8,
  height.ratio = c(2, 1),
  width.ratio = c(1, 3)
)
}
\arguments{
\item{vp}{A matrix, which contains the output of variation partitioning (i.e. commonality analysis) from \code{rdacca.hp},\code{glmm.hp},\code{gam.hp},and \code{phylolm.hp}.}

\item{hp}{A matrix, which contains the output of hierarchical partitioning from \code{rdacca.hp},\code{glmm.hp},\code{gam.hp},and \code{phylolm.hp}.}

\item{plot.hp}{The default is \code{TRUE}, which plots the individual effect for each predictor on left column diagram. If \code{FALSE}, compute and plot the sum of unique effect and common effect for each predictor.}

\item{order.part}{How the VP components in matrix layout should be ordered. Options include \code{"effect"} (order the intersections by their effects) or \code{"degree"} (sort by the number of predictors involved in the intersection), default is \code{"effect"}.}

\item{decreasing.part}{How the intersections in \code{order.part} should be ordered. Default is \code{TRUE}, \code{"effect"} is decreasing (from greatest to least) or \code{"degree"} is increasing (from least to greatest).}

\item{order.var}{The predictors in the matrix layout should be ordered by. Default is \code{TRUE}, which orders the predictors by their effects. IF \code{FALSE}, sort by the order of predictors in input data.}

\item{decreasing.var}{If \code{order.var=TRUE}, how the predictors should be ordered. Default is \code{TRUE}, from greatest to least.}

\item{cutoff}{Effects below \code{cutoff} will not be displayed, default is \code{-1}. Note: Negative effects due to adjustment of R-squared mean negligible contributions, but they are included in the computation of the total contribution of each predictor category.}

\item{nVar}{Number of components in VP to plot, default is \code{30}.}

\item{col.width}{Width of bars in column diagram, default is \code{0.6}.}

\item{pch.size}{Size of points in matrix diagram, default is \code{3}.}

\item{line.lwd}{Width of lines in matrix diagram, default is \code{0.5}.}

\item{show.effect}{Show the relative importance of predictors (unique, common, or individual effects) above bars, default is \code{TRUE}.}

\item{effect.cex}{Font size of the effects, default is \code{2.7}.}

\item{title.cex}{Font size of axis titles, default is \code{10}.}

\item{axis.cex}{Font size of axis labels, default is \code{8}.}

\item{height.ratio}{Ratio between matrix and top column diagram, default is \code{c(2, 1)}.}

\item{width.ratio}{Ratio between matrix and left column diagram, default is \code{c(1, 3)}.}
}
\value{
\itemize{Returns a ggplot2.}
}
\description{
Visualization of variation partitioning (VP) and hierarchical partitioning (HP) with unlimited number of predictor variables (or matrices of predictors) using UpSet matrix layout.
}
\details{
upset.hp diagram is an extension of UpSet technique to  and is used to visualize the object of \code{rdacca.hp},\code{glmm.hp},\code{gam.hp},and \code{phylolm.hp} (Lai et al. 2022a,2022b,2023,2024; Liu et al. 2023). The matrix layout enables the effective representation of relative importance of predictors, such as the unique effects and common effects in VP, as well as additional summary statistics or individual effects in HP. upset.hp diagram could, in principle, allow visualization of any number of predictor variables or groups of predictor variables. But considering the interpretability of data, we would like to recommend that the number of predictors (or groups of predictors) no more than 7.
}
\examples{
library(glmm.hp)
#upset for glmm.hp() in lm()
m2<-lm(mpg~wt+carb+cyl,mtcars)
vp <- glmm.hp(m2,commonality=TRUE)$commonality.analysis
hp <- glmm.hp(m2)$hierarchical.partitioning
upset.hp(vp,hp)
}
\references{
Lai J., Zou Y., Zhang J., Peres-Neto P. (2022) Generalizing hierarchical and variation partitioning in multiple regression and canonical analyses using the rdacca.hp R package. Methods in Ecology and Evolution, 13:782-788.

Lai J.,Zou Y., Zhang S.,Zhang X.,Mao L.(2022)glmm.hp: an R package for computing individual effect of predictors in generalized linear mixed models.Journal of Plant Ecology,15(6):1302-1307<DOI:10.1093/jpe/rtac096>

Lai J.,Zhu W., Cui D.,Mao L.(2023)Extension of the glmm.hp package to Zero-Inflated generalized linear mixed models and multiple regression.Journal of Plant Ecology,16(6):rtad038<DOI:10.1093/jpe/rtad038>

Liu Y., Yu X., Yu Y., et al. (2023) Application of "rdacca. hp" R package in ecological data analysis: case and progress. Chinese Journal of Plant Ecology, 27:134-144.

Lai J.,Tang J., Li T., Zhang A.,Mao L.(2024)Evaluating the relative importance of predictors in Generalized Additive Models using the gam.hp R package.Plant Diversity,46(4):542-546<DOI:10.1016/j.pld.2024.06.002>
}
