% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_groups.R
\name{bitly_retrieve_links_grouped}
\alias{bitly_retrieve_links_grouped}
\title{Retrieve Bitlinks by Group}
\usage{
bitly_retrieve_links_grouped(group_id = NA, keyword = NULL,
  search_query = NULL, created_before = NULL, created_after = NULL,
  modified_after = NULL, archived = "off", deeplinks = "both",
  domain_deeplinks = "both", campaign_guid = NULL,
  channel_guid = NULL, custom_bitlink = "both", tags = NULL,
  encoding_login = NULL, page = 1, size = 50, showRequestURL = F)
}
\arguments{
\item{group_id}{- a required string | A GUID for a Bitly group}

\item{keyword}{- Custom keyword to filter on history entries}

\item{search_query}{- string | the value that you would like to search}

\item{created_before}{- Timestamp as an integer unix epoch}

\item{created_after}{- Timestamp as an integer unix epoch}

\item{modified_after}{- Timestamp as an integer unix epoch, 
see \code{\link[lubridate]{as_datetime}} or \code{anytime}'s \code{as_datetime}}

\item{archived}{- string | Default: "off" | Enum:"on" "off" "both" | Whether or not to include archived bitlinks}

\item{deeplinks}{- string | Default: "both" | Enum:"on" "off" "both" | Filter to only Bitlinks that contain deeplinks}

\item{domain_deeplinks}{- string | Default: "both" | Enum:"on" "off" "both" | Filter to only Bitlinks 
that contain deeplinks configured with a custom domain}

\item{campaign_guid}{- Filter to return only links for the given campaign GUID, can be provided}

\item{channel_guid}{- Filter to return only links for the given channel GUID, 
can be provided, overrides all other parameters}

\item{custom_bitlink}{- string | Default: "both" | Enum:"on" "off" "both"}

\item{tags}{- Array of string | filter by given tags}

\item{encoding_login}{- Array of string | Filter by the login of the authenticated user that created the Bitlink}

\item{page}{- Default: 1 | Integer specifying the numbered result at which to start}

\item{size}{- string |  Default: 50 | The quantity of items to be be returned}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been 
build and requested from server. For debug purposes, default FALSE.}
}
\description{
Retrieve a paginated collection of Bitlinks for a Group
}
\section{Group}{

Groups are a subdivision within an organization. A user will belong to a group within an organization.
Most actions on our API will be on behalf of a group. For example, when you
shorten a link, it will be on behalf of a user and a group.
}

\examples{
\dontrun{
ui <- bitly_user_info(showRequestURL = TRUE)
rg <- bitly_retrieve_links_grouped(group_id = ui$default_group_guid[1])
}

}
\seealso{
\url{https://dev.bitly.com/v4/#operation/getBitlinksByGroup}
}
