% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_links.R
\name{bitly_retrieve_metrics_by_referrers}
\alias{bitly_retrieve_metrics_by_referrers}
\title{Get Metrics for a Bitlink by referrers}
\usage{
bitly_retrieve_metrics_by_referrers(bitlink = NULL, size = 100,
  unit = NULL, unit_reference = NULL, units = -1,
  showRequestURL = FALSE)
}
\arguments{
\item{bitlink}{- required, a Bitlink made of the domain and hash}

\item{size}{- The quantity of items to be be returned}

\item{unit}{- A unit of time}

\item{unit_reference}{- string | An ISO-8601 timestamp, indicating the most recent time for 
which to pull metrics. Will default to current time.}

\item{units}{- An integer representing the time units to query data for. pass -1 to return all units of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug
purposes.}
}
\description{
This endpoint will return metrics about the referrers referring click traffic to 
a single Bitlink.
}
\examples{
\dontrun{
bitly_retrieve_metrics_by_referrers(bitlink = "bit.ly/DPetrov", unit = "day", 
units = -1, size = 100)
}

}
\seealso{
\url{https://dev.bitly.com/v4/#operation/getMetricsForBitlinkByReferrers}
}
