% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_orgs.R
\name{bitly_retrieve_org_shorten_counts}
\alias{bitly_retrieve_org_shorten_counts}
\title{Retrieve Organization Shorten Counts}
\usage{
bitly_retrieve_org_shorten_counts(organization_id = NULL)
}
\arguments{
\item{organization_id}{- a required string | A GUID for a Bitly organization.
You may also simply pass "" (double quotes), but this should be avoided at all costs.}
}
\value{
facet - Enum: "countries" "referrers" "referrers_by_domain" "referring_domains" "referring_networks" "shorten_counts"
}
\description{
Retrieve all the shorten counts for a specific organization
}
\section{Organizations}{

Organizations are part of our hierarchy. This is the top level where a group and user will belong.
}

\examples{
\dontrun{
all_orgs <- bitly_retrieve_orgs()
osc <- bitly_org_shorten_counts(organization_id = all_orgs$guid)
df_org_short_counts <- data.frame(osc, stringsAsFactors = FALSE)
}

}
\seealso{
\url{https://dev.bitly.com/v4/#operation/getOrganizationShortenCounts}
}
