% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_user_app_info.R
\name{bitly_user_info}
\alias{bitly_user_info}
\title{Retrieve information for the current authenticated user}
\usage{
bitly_user_info(showRequestURL = FALSE)
}
\arguments{
\item{showRequestURL}{- an optional T/F value to whether show URL which has been 
build and requested from server. For debug purposes, default FALSE.}
}
\value{
login - the specified bitly login or the login of the authenticated user

name - the user's full/display name

default_group_guid	- a group to which user belongs

created - Timestamp for the moment the user signed up (uses \code{\link[lubridate]{ymd_hms}})

is_active - whether a user profile is active

modified - Timestamp of the last modification to the user profile (uses \code{\link[lubridate]{ymd_hms}})

is_sso_user - is Single-Sign-On enabled for the user (PREMIUM FEATURE) ? (\href{https://support.bitly.com/hc/en-us/articles/360001482672-What-is-Single-Sign-On-SSO-}{Bit.ly SSO})

is_2fa_enabled - is 2 Step verification enabled ? (\href{https://support.bitly.com/hc/en-us/articles/230650187-What-is-2-step-verification-}{Bit.ly 2FA})

email - user's emails
}
\description{
Retrieve information for the current authenticated user
}
\section{User}{

User operations such as changing your name or fetching basic user information apply only to the authenticated user.
}

\examples{
\dontrun{
   ui <- bitly_user_info(showRequestURL = TRUE)
}

}
\seealso{
\url{https://dev.bitly.com/v4/#operation/getUser}
}
